// table of the bits for the 8x12 character set
// each byte hold 8 bits of a row, the upper bit is 1, the bit for the 8th line is 128
 #ifdef LCD_CYRILLIC                                      
  #define CHAR_COUNT12 (Cyr_ja + 1)
 #else
  #define CHAR_COUNT12 128
 #endif
 #if defined(MAIN_C)
const unsigned char PROGMEM font[CHAR_COUNT12][(FONT_WIDTH * ((FONT_HEIGHT + 7)/8))]={
 /* 0x00 Resistor3  */                
{ 0x60,0xF8,0x98,0x98,0x98,0x98,0xF8,0x60,
  0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x01 Diode1  */                    
{ 0x60,0xFE,0xFC,0xF8,0xF0,0x60,0xFE,0x60,
  0x00,0x07,0x03,0x01,0x00,0x00,0x07,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x02 Diode2  */                  
{ 0x60,0xFE,0x60,0xF0,0xF8,0xFC,0xFE,0x60,
  0x00,0x07,0x00,0x00,0x01,0x03,0x07,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x03 Capacitor  */               
{ 0x60,0xFE,0xFE,0x00,0x00,0xFE,0xFE,0x60,
  0x00,0x07,0x07,0x00,0x00,0x07,0x07,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x04 Omega  */                   
{ 0x38,0x7C,0xC6,0x06,0xC6,0x7C,0x38,0x00,
  0x03,0x03,0x03,0x00,0x03,0x03,0x03,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x05 mu  */                      
{ 0x00,0xFC,0xFC,0x00,0x00,0xF0,0xF0,0x00,
  0x0E,0x07,0x01,0x02,0x01,0x03,0x03,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x06 Resistor1  */               
{ 0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,0xFC,0x60,
  0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x07 Resistor2  */               
{ 0x60,0xFC,0x0C,0x0C,0x0C,0x0C,0x0C,0x0C,
  0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x08  */                         
{ 0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x09  */                         
{ 0x60,0x60,0xE0,0x00,0x00,0xC0,0xC0,0x00,
  0x00,0x00,0x01,0x03,0x03,0x01,0x01,0x03 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x0a  */                         
{ 0x00,0xC0,0xC0,0x00,0x00,0xE0,0x60,0x60,
  0x03,0x01,0x01,0x03,0x03,0x01,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x0b  */                         
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x0c  */                         
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x0d  */                         
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x0e  */                         
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x0f  */                         
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
#ifdef LANG_CZECH									  
 /* 0x10 Cz_a */                    
{ 0x0,0xC0,0xE8,0x2A,0x4B,0xF9,0xF0,0x0,
  0x0,0x1,0x3,0x2,0x2,0x3,0x3,0x0

  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x11 Cz_c */                    
{ 0x0,0xF1,0xFB,0xA,0xB,0x19,0x10,0x0,
  0x0,0x1,0x3,0x2,0x2,0x3,0x1,0x0
 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x12 Cz_d*/               
{ 0x0,0xF0,0xF8,0x8,0x10,0xFF,0x4,0x3,
  0x0,0x1,0x3,0x2,0x2,0x3,0x0,0x0
 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x13 Cz_e */                    
{ 0x0,0xF0,0xF8,0x4A,0x4B,0x79,0x70,0x0,
  0x0,0x1,0x3,0x2,0x2,0x3,0x1,0x0
 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x14 ,Cz_ee */                   
{ 0x0,0xF1,0xFB,0x4A,0x4B,0x79,0x70,0x0,
  0x0,0x1,0x3,0x2,0x2,0x3,0x1,0x0

  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x15 Cz_i */                    
{ 0x0,0x0,0x8,0xFA,0xFB,0x1,0x0,0x0,
  0x0,0x0,0x2,0x3,0x3,0x2,0x0,0x0
 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x16 Cz_n */                 
{ 0x0,0xF9,0xFB,0x32,0x1B,0xF9,0xF0,0x0,
  0x0,0x3,0x3,0x0,0x0,0x3,0x3,0x0
 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x17 Cz_o */                         
{ 0x0,0xF0,0xF8,0xA,0xB,0xF9,0xF0,0x0,
  0x0,0x1,0x3,0x2,0x2,0x3,0x1,0x0
 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x18 Cz_r */                         
{ 0x0,0xF9,0xFB,0x32,0x1B,0x39,0x30,0x0,
  0x0,0x3,0x3,0x0,0x0,0x0,0x0,0x0
 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x19 Cz_s */                         
{ 0x0,0x31,0x7B,0x4A,0x4B,0xD9,0x90,0x0,
  0x0,0x1,0x3,0x2,0x2,0x3,0x1,0x0
 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x1a Cz_t */                         
{ 0x8,0x8,0xFE,0xFF,0x8,0x8,0x3,0x1,
  0x0,0x0,0x1,0x3,0x2,0x3,0x1,0x0

  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x1b Cz_u */                         
{ 0x0,0xF8,0xF8,0x2,0x3,0xF9,0xF8,0x0,
  0x0,0x1,0x3,0x2,0x1,0x3,0x3,0x0
 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x1c Cz_uu */                         
{ 0x0,0xF8,0xFA,0x5,0x5,0xFA,0xF8,0x0,
  0x0,0x1,0x3,0x2,0x1,0x3,0x3,0x0
 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x1d Cz_y */                         
{ 0x0,0x78,0xF8,0x82,0x43,0xF9,0xF8,0x0,
  0x0,0x2,0x6,0x4,0x4,0x7,0x3,0x0

  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x1e Cz_z */                         
{ 0x0,0x19,0x9B,0xCA,0x6B,0x39,0x18,0x0,
  0x0,0x3,0x3,0x2,0x2,0x3,0x3,0x0
 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x1f  */                         
{ 0x0,0x6,0xC6,0xF3,0x3A,0xF,0x2,0x0,
  0x0,0x3,0x3,0x2,0x2,0x3,0x3,0x0
   },  /* x=0, y=0, w=8, h=16 */           				
#else

 /* 0x10 Cry_D */                    
{ 0x00,0xFC,0xFE,0x03,0x01,0xFF,0xFF,0x00,
  0x06,0x07,0x03,0x02,0x02,0x03,0x07,0x06 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x11 Cyr_C */                    
{ 0x00,0xFF,0xFF,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x03,0x03,0x02,0x02,0x03,0x07,0x06 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x12 Cyr_Schtsch*/               
{ 0xFF,0xFF,0x00,0xFF,0x00,0xFF,0xFF,0x00,
  0x03,0x03,0x02,0x03,0x02,0x03,0x07,0x07 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x13 Cyr_d */                    
{ 0x00,0xC0,0xE0,0x30,0x18,0xF8,0xF8,0x00,
  0x06,0x07,0x03,0x02,0x02,0x03,0x07,0x06 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x14 ,Cyr_f */                   
{ 0xF0,0xF8,0x08,0xFE,0x08,0xF8,0xF0,0x00,
  0x01,0x03,0x02,0x0F,0x02,0x03,0x01,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x15 Cyr_c */                    
{ 0x00,0xF8,0xF8,0x00,0x00,0xF8,0xF8,0x00,
  0x00,0x03,0x03,0x02,0x02,0x03,0x07,0x07 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x16 Cyr_scht */                 
{ 0xF8,0xF8,0x00,0xF8,0x00,0xF8,0xF8,0x00,
  0x03,0x03,0x02,0x03,0x02,0x03,0x07,0x07 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x17  */                         
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x18  */                         
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x19  */                         
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x1a  */                         
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x1b  */                         
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x1c  */                         
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x1d  */                         
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x1e  */                         
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x1f  */                         
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */  
#endif     
                                
 /* 0x20 ' ' */                      
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x21 '!' */                      
{ 0x00,0x00,0x1E,0xFF,0xFF,0x1E,0x00,0x00,
  0x00,0x00,0x00,0x0D,0x0D,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x22 '"' */                      
{ 0x00,0x08,0x0F,0x07,0x08,0x0F,0x07,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x23 '#' */                      
{ 0x00,0x84,0xFF,0x84,0x84,0xFF,0x84,0x00,
  0x00,0x00,0x03,0x00,0x00,0x03,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x24 '$' */                      
{ 0x00,0x1C,0xFF,0x22,0x42,0xFF,0x84,0x00,
  0x00,0x02,0x0F,0x04,0x04,0x0F,0x03,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x25 '%' */                      
{ 0x00,0x1E,0x92,0xEE,0x30,0x9C,0x86,0x00,
  0x00,0x06,0x03,0x00,0x07,0x04,0x07,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x26 '&' */                      
{ 0xC0,0x6E,0x3B,0x31,0x7B,0xCE,0x60,0x00,
  0x01,0x03,0x02,0x02,0x03,0x01,0x03,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x27 ''' */                      
{ 0x00,0x00,0x08,0x0F,0x07,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x28 '(' */                      
{ 0x00,0xF8,0xFC,0x06,0x03,0x01,0x00,0x00,
  0x00,0x01,0x03,0x06,0x0C,0x08,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x29 ')' */                      
{ 0x00,0x00,0x01,0x03,0x06,0xFC,0xF8,0x00,
  0x00,0x00,0x08,0x0C,0x06,0x03,0x01,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x2a '*' */                      
{ 0x00,0xB4,0xFC,0x78,0x78,0xFC,0xB4,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x2b '+' */                      
{ 0x00,0x30,0x30,0xFE,0xFE,0x30,0x30,0x00,
  0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x2c ',' */                      
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x08,0x0F,0x07,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x2d '-' */                      
{ 0x00,0x60,0x60,0x60,0x60,0x60,0x60,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x2e '.' */                      
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x07,0x07,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x2f '/' */                      
{ 0x00,0x80,0xC0,0x70,0x38,0x0C,0x07,0x03,
  0x03,0x03,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x30 '0' */                      
{ 0x00,0xFE,0xFF,0x01,0x01,0xFF,0xFE,0x00,
  0x00,0x01,0x03,0x02,0x02,0x03,0x01,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x31 '1' */                      
{ 0x00,0x0C,0x06,0xFF,0xFF,0x00,0x00,0x00,
  0x00,0x02,0x02,0x03,0x03,0x02,0x02,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x32 '2' */                      
{ 0x00,0x06,0x87,0xC1,0x61,0x3F,0x1E,0x00,
  0x00,0x03,0x03,0x02,0x02,0x03,0x03,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x33 '3' */                      
{ 0x00,0x03,0x01,0x09,0x1D,0xF7,0xE3,0x00,
  0x00,0x01,0x03,0x02,0x02,0x03,0x01,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x34 '4' */                      
{ 0x70,0x7F,0x4F,0x40,0xFC,0xFC,0x40,0x00, 
  0x00,0x00,0x00,0x02,0x03,0x03,0x02,0x00
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x35 '5' */                      
{ 0x00,0x1F,0x1F,0x09,0x09,0xF9,0xF1,0x00,
  0x00,0x01,0x03,0x02,0x02,0x03,0x01,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x36 '6' */                      
{ 0x00,0xFC,0xFE,0x13,0x11,0xF1,0xE0,0x00,
  0x00,0x01,0x03,0x02,0x02,0x03,0x01,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x37 '7' */                      
{ 0x00,0x03,0x03,0xE1,0xF1,0x1F,0x0F,0x00,
  0x00,0x00,0x00,0x03,0x03,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x38 '8' */                      
{ 0x00,0xEE,0xFF,0x11,0x11,0xFF,0xEE,0x00,
  0x00,0x01,0x03,0x02,0x02,0x03,0x01,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x39 '9' */                      
{ 0x00,0x1E,0x3F,0x21,0x21,0xFF,0xFE,0x00,
  0x00,0x00,0x02,0x02,0x03,0x01,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x3a ':' */                      
{ 0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,
  0x00,0x00,0x00,0x03,0x03,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x3b ';' */                      
{ 0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,
  0x00,0x00,0x04,0x07,0x03,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x3c '<' */                      
{ 0x00,0x60,0xF0,0x98,0x0C,0x06,0x02,0x00,
  0x00,0x00,0x00,0x01,0x03,0x06,0x04,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x3d '=' */                      
{ 0x00,0x98,0x98,0x98,0x98,0x98,0x98,0x00,
  0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x3e '>' */                      
{ 0x00,0x02,0x06,0x0C,0x98,0xF0,0x60,0x00,
  0x00,0x04,0x06,0x03,0x01,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x3f '?' */                      
{ 0x00,0x06,0x07,0xC1,0xE1,0x3F,0x1E,0x00,
  0x00,0x00,0x00,0x06,0x06,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x40 '@' */                      
{ 0x00,0xFE,0xFF,0x01,0x79,0x4B,0x7E,0x00,
  0x00,0x01,0x03,0x02,0x02,0x03,0x01,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x41 'A' */                      
{ 0x00,0xFC,0xFE,0x23,0x23,0xFE,0xFC,0x00,
  0x00,0x03,0x03,0x00,0x00,0x03,0x03,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x42 'B' */                      
{ 0x00,0xFF,0xFF,0x11,0x11,0xFF,0xEE,0x00,
  0x00,0x03,0x03,0x02,0x02,0x03,0x01,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x43 'C' */                      
{ 0x00,0xFE,0xFF,0x01,0x01,0x03,0x02,0x00,
  0x00,0x01,0x03,0x02,0x02,0x03,0x01,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x44 'D' */                      
{ 0x00,0xFF,0xFF,0x01,0x01,0xFF,0xFE,0x00,
  0x00,0x03,0x03,0x02,0x02,0x03,0x01,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x45 'E' */                      
{ 0x00,0xFF,0xFF,0x11,0x11,0x13,0x03,0x00,
  0x00,0x03,0x03,0x02,0x02,0x03,0x03,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x46 'F' */                      
{ 0x00,0xFF,0xFF,0x11,0x11,0x13,0x03,0x00,
  0x00,0x03,0x03,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x47 'G' */                      
{ 0x00,0xFE,0xFF,0x01,0x41,0xC3,0xC2,0x00,
  0x00,0x01,0x03,0x02,0x02,0x03,0x03,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x48 'H' */                      
{ 0x00,0xFF,0xFF,0x10,0x10,0xFF,0xFF,0x00,
  0x00,0x03,0x03,0x00,0x00,0x03,0x03,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x49 'I' */                      
{ 0x00,0x00,0x01,0xFF,0xFF,0x01,0x00,0x00,
  0x00,0x00,0x02,0x03,0x03,0x02,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x4a 'J' */                      
{ 0x00,0x83,0x83,0x01,0x01,0xFF,0xFF,0x00,
  0x00,0x01,0x03,0x02,0x02,0x03,0x01,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x4b 'K' */                      
{ 0x00,0xFF,0xFF,0x10,0x38,0xEF,0xC7,0x00,
  0x00,0x03,0x03,0x00,0x00,0x03,0x03,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x4c 'L' */                      
{ 0x00,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,
  0x00,0x03,0x03,0x02,0x02,0x03,0x03,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x4d 'M' */                      
{ 0xFF,0xFE,0x1C,0x78,0x1C,0xFE,0xFF,0x00,
  0x03,0x03,0x00,0x00,0x00,0x03,0x03,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x4e 'N' */                      
{ 0x00,0xFF,0xFF,0x1C,0xE0,0xFF,0xFF,0x00,
  0x00,0x03,0x03,0x00,0x00,0x03,0x03,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x4f 'O' */                      
{ 0x00,0xFE,0xFF,0x01,0x01,0xFF,0xFE,0x00,
  0x00,0x01,0x03,0x02,0x02,0x03,0x01,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x50 'P' */                      
{ 0x00,0xFF,0xFF,0x21,0x21,0x3F,0x1E,0x00,
  0x00,0x03,0x03,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x51 'Q' */                      
{ 0x00,0xFE,0xFF,0x01,0xC1,0xBF,0xFE,0x00,
  0x00,0x01,0x03,0x03,0x03,0x01,0x03,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x52 'R' */                      
{ 0x00,0xFF,0xFF,0x21,0x71,0xDF,0x8E,0x00,
  0x00,0x03,0x03,0x00,0x00,0x03,0x03,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x53 'S' */                      
{ 0x00,0x0E,0x1F,0x31,0x31,0xE3,0xC2,0x00,
  0x00,0x01,0x03,0x02,0x02,0x03,0x01,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x54 'T' */                      
{ 0x00,0x03,0x01,0xFF,0xFF,0x01,0x03,0x00,
  0x00,0x00,0x02,0x03,0x03,0x02,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x55 'U' */                      
{ 0x00,0xFF,0xFF,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x01,0x03,0x02,0x02,0x03,0x01,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x56 'V' */                      
{ 0x00,0x3F,0xFF,0xC0,0xC0,0xFF,0x3F,0x00,
  0x00,0x00,0x00,0x03,0x03,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x57 'W' */                      
{ 0x7F,0xFF,0xC0,0x78,0xC0,0xFF,0x7F,0x00,
  0x00,0x03,0x03,0x00,0x03,0x03,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x58 'X' */                      
{ 0x00,0x87,0xCF,0x78,0x78,0xCF,0x87,0x00,
  0x00,0x03,0x03,0x00,0x00,0x03,0x03,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x59 'Y' */                      
{ 0x00,0x0F,0x1F,0xF0,0xF0,0x1F,0x0F,0x00,
  0x00,0x00,0x02,0x03,0x03,0x02,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x5a 'Z' */                      
{ 0x00,0x03,0xC3,0xF1,0x3D,0x0F,0x03,0x00,
  0x00,0x03,0x03,0x02,0x02,0x03,0x03,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x5b '[' */                      
{ 0x00,0x00,0xFF,0xFF,0x01,0x01,0x00,0x00,
  0x00,0x00,0x07,0x07,0x04,0x04,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x5c '\' */                      
{ 0x03,0x07,0x0C,0x38,0x70,0xC0,0x80,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x03 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x5d ']' */                      
{ 0x00,0x00,0x01,0x01,0xFF,0xFF,0x00,0x00,
  0x00,0x00,0x04,0x04,0x07,0x07,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x5e '^' */                      
{ 0x08,0x0C,0x06,0x03,0x06,0x0C,0x08,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x5f '_' */                      
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x60 '`' */                      
{ 0x00,0x00,0x00,0x07,0x0F,0x08,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x61 'a' */                      
{ 0x00,0xC0,0xE8,0x28,0x48,0xF8,0xF0,0x00,
  0x00,0x01,0x03,0x02,0x02,0x03,0x03,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x62 'b' */                      
{ 0x00,0xFF,0xFF,0x10,0x08,0xF8,0xF0,0x00,
  0x00,0x03,0x03,0x02,0x02,0x03,0x01,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x63 'c' */                      
{ 0x00,0xF0,0xF8,0x08,0x08,0x18,0x10,0x00,
  0x00,0x01,0x03,0x02,0x02,0x03,0x01,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x64 'd' */                      
{ 0x00,0xF0,0xF8,0x08,0x10,0xFF,0xFF,0x00,
  0x00,0x01,0x03,0x02,0x02,0x03,0x03,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x65 'e' */                      
{ 0x00,0xF0,0xF8,0x48,0x48,0x78,0x70,0x00,
  0x00,0x01,0x03,0x02,0x02,0x03,0x01,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x66 'f' */                      
{ 0x00,0x08,0xFE,0xFF,0x09,0x03,0x02,0x00,
  0x00,0x02,0x03,0x03,0x02,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x67 'g' */                      
{ 0x00,0x70,0xF8,0x88,0x48,0xF8,0xF8,0x00,
  0x00,0x02,0x06,0x04,0x04,0x07,0x03,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x68 'h' */                      
{ 0x00,0xFF,0xFF,0x10,0x08,0xF8,0xF0,0x00,
  0x00,0x03,0x03,0x00,0x00,0x03,0x03,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x69 'i' */                      
{ 0x00,0x00,0x08,0xFB,0xFB,0x00,0x00,0x00,
  0x00,0x00,0x02,0x03,0x03,0x02,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x6a 'j' */                      
{ 0x00,0x00,0x00,0x00,0x08,0xFB,0xFB,0x00,
  0x00,0x02,0x06,0x04,0x04,0x07,0x03,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x6b 'k' */                      
{ 0x00,0xFF,0xFF,0x40,0xE0,0xB8,0x18,0x00,
  0x00,0x03,0x03,0x00,0x00,0x03,0x03,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x6c 'l' */                      
{ 0x00,0x00,0x01,0xFF,0xFF,0x00,0x00,0x00,
  0x00,0x00,0x02,0x03,0x03,0x02,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x6d 'm' */                      
{ 0xF8,0xF0,0x18,0xF0,0x18,0xF8,0xF0,0x00,
  0x03,0x03,0x00,0x01,0x00,0x03,0x03,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x6e 'n' */                      
{ 0x00,0xF8,0xF8,0x30,0x18,0xF8,0xF0,0x00,
  0x00,0x03,0x03,0x00,0x00,0x03,0x03,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x6f 'o' */                      
{ 0x00,0xF0,0xF8,0x08,0x08,0xF8,0xF0,0x00,
  0x00,0x01,0x03,0x02,0x02,0x03,0x01,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x70 'p' */                      
{ 0x00,0xF8,0xF8,0x88,0x08,0xF8,0xF0,0x00,
  0x00,0x07,0x07,0x00,0x01,0x01,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x71 'q' */                      
{ 0x00,0xF0,0xF8,0x08,0x88,0xF8,0xF8,0x00,
  0x00,0x00,0x01,0x01,0x00,0x07,0x07,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x72 'r' */                      
{ 0x00,0xF8,0xF8,0x30,0x18,0x38,0x30,0x00,
  0x00,0x03,0x03,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x73 's' */                      
{ 0x00,0x30,0x78,0x48,0x48,0xD8,0x90,0x00,
  0x00,0x01,0x03,0x02,0x02,0x03,0x01,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x74 't' */                      
{ 0x08,0x08,0xFE,0xFF,0x08,0x08,0x00,0x00,
  0x00,0x00,0x01,0x03,0x02,0x03,0x01,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x75 'u' */                      
{ 0x00,0xF8,0xF8,0x00,0x00,0xF8,0xF8,0x00,
  0x00,0x01,0x03,0x02,0x01,0x03,0x03,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x76 'v' */                      
{ 0x00,0x38,0xF8,0xC0,0xC0,0xF8,0x38,0x00,
  0x00,0x00,0x00,0x03,0x03,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x77 'w' */                      
{ 0xF8,0xF8,0x80,0xF0,0x80,0xF8,0xF8,0x00,
  0x00,0x03,0x03,0x00,0x03,0x03,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x78 'x' */                      
{ 0x00,0x98,0xF8,0x60,0x60,0xF8,0x98,0x00,
  0x00,0x03,0x03,0x00,0x00,0x03,0x03,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x79 'y' */                      
{ 0x00,0x78,0xF8,0x80,0x40,0xF8,0xF8,0x00,
  0x00,0x02,0x06,0x04,0x04,0x07,0x03,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x7a 'z' */                      
{ 0x00,0x18,0x98,0xC8,0x68,0x38,0x18,0x00,
  0x00,0x03,0x03,0x02,0x02,0x03,0x03,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x7b '{' */                      
{ 0x00,0x60,0x60,0x9E,0x9F,0x01,0x01,0x00,
  0x00,0x00,0x00,0x07,0x0F,0x08,0x08,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x7c '|' */                      
{ 0x00,0x00,0x00,0x9F,0x9F,0x00,0x00,0x00,
  0x00,0x00,0x00,0x0F,0x0F,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x7d '}' */                      
{ 0x00,0x01,0x01,0x9F,0x9E,0x60,0x60,0x00,
  0x00,0x08,0x08,0x0F,0x07,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x7e '~' */                      
{ 0x00,0x04,0x06,0x02,0x06,0x04,0x06,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x7f  */                         
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,                 
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00                  
  },  /* x=0, y=0, w=8, h=16 */
	
 #if 0
 /* 0x80  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x81  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x82  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x83  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x84  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x85  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x86  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x87  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x88  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x89  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x8a  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x8b  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x8c  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x8d  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x8e  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x8f  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x90  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x91  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x92  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x93  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x94  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x95  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x96  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x97  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x98  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x99  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x9a  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x9b  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x9c  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x9d  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x9e  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0x9f  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	
 #endif                                   
#ifdef LCD_CYRILLIC                       
 /* 0xa0, Cyr_B  */                       
{ 0x00,0xFF,0xFF,0x09,0x09,0xFB,0xF3,0x00,
  0x00,0x03,0x03,0x02,0x02,0x03,0x01,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xa1, Cyr_G  */                       
{ 0x00,0xFF,0xFF,0x01,0x01,0x03,0x03,0x00,
  0x00,0x03,0x03,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xa2, Cyr_Jo  */                      
{ 0x00,0xFD,0xFD,0x24,0x24,0x25,0x0D,0x00,
  0x00,0x03,0x03,0x02,0x02,0x02,0x03,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xa3, Cyr_Zsch */                     
{ 0xC7,0xEF,0x38,0xFF,0x38,0xEF,0xC7,0x00,
  0x03,0x03,0x00,0x03,0x00,0x03,0x03,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xa4, Cyr_Z */                        
{ 0x00,0x02,0x13,0x11,0x11,0xFF,0xEE,0x00,
  0x00,0x01,0x03,0x02,0x02,0x03,0x01,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xa5, Cyr_I */                        
{ 0x00,0xFF,0xFF,0xE0,0x1C,0xFF,0xFF,0x00,
  0x00,0x03,0x03,0x00,0x00,0x03,0x03,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xa6, Cyr_J  */                       
{ 0x00,0xFC,0xFC,0xC2,0x3B,0xFD,0xFC,0x00,
  0x00,0x03,0x03,0x01,0x00,0x03,0x03,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xa7, Cyr_L  */                       
{ 0x00,0xF8,0xFC,0x06,0x03,0xFF,0xFF,0x00,
  0x00,0x03,0x03,0x00,0x00,0x03,0x03,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xa8, Cyr_P  */                       
{ 0x00,0xFF,0xFF,0x01,0x01,0xFF,0xFF,0x00,
  0x00,0x03,0x03,0x00,0x00,0x03,0x03,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xa9, Cyr_U  */                       
{ 0x00,0x1F,0x3F,0x20,0x20,0xFF,0xFF,0x00,
  0x00,0x01,0x03,0x02,0x02,0x03,0x01,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xaa, Cyr_F  */                       
{ 0xFC,0xFE,0x02,0xFF,0x02,0xFE,0xFC,0x00,
  0x00,0x01,0x01,0x07,0x01,0x01,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xab, Cyr_Tsch  */                    
{ 0x00,0x1F,0x3F,0x20,0x20,0xFF,0xFF,0x00,
  0x00,0x00,0x00,0x00,0x00,0x03,0x03,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xac, Cyr_Sch  */                     
{ 0xFF,0xFF,0x00,0xFF,0x00,0xFF,0xFF,0x00,
  0x03,0x03,0x02,0x03,0x02,0x03,0x03,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xad, Cyr_HH */                       
{ 0x07,0xFF,0xFF,0x20,0x10,0xF0,0xE0,0x00,
  0x00,0x03,0x03,0x02,0x02,0x03,0x01,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xae, Cyr_Y */                        
{ 0xFF,0xFF,0x10,0xE0,0x00,0xFF,0xFF,0x00,
  0x03,0x03,0x02,0x01,0x00,0x03,0x03,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xaf, Cyr_E */                        
{ 0x00,0x02,0x13,0x11,0x11,0xFF,0xFE,0x00,
  0x00,0x01,0x03,0x02,0x02,0x03,0x01,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xb0, Cyr_Ju */                       
{ 0xFF,0xFF,0x18,0xFE,0x01,0xFF,0xFE,0x00,
  0x03,0x03,0x00,0x01,0x02,0x03,0x01,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xb1, Cyr_Ja */                       
{ 0x00,0x8E,0xDF,0x71,0x21,0xFF,0xFF,0x00,
  0x00,0x03,0x03,0x00,0x00,0x03,0x03,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xb2, Cyr_b */                        
{ 0x00,0xF8,0xFC,0x26,0x12,0xF3,0xE1,0x00,
  0x00,0x01,0x03,0x02,0x02,0x03,0x01,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xb3, Cyr_v */                        
{ 0x00,0xF8,0xF8,0x48,0x48,0xF8,0xB0,0x00,
  0x00,0x03,0x03,0x02,0x02,0x03,0x01,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xb4, Cyr_g */                        
{ 0x00,0xF8,0xF8,0x08,0x08,0x18,0x18,0x00,
  0x00,0x03,0x03,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xb5, Cyr_jo */                       
{ 0x00,0xF2,0xFA,0x48,0x48,0x7A,0x72,0x00,
  0x00,0x01,0x03,0x02,0x02,0x02,0x01,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xb6, Cyr_zsch */                     
{ 0x98,0xF8,0x60,0xF8,0x60,0xF8,0x98,0x00,
  0x03,0x03,0x00,0x03,0x00,0x03,0x03,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xb7, Cyr_z */                        
{ 0x00,0x10,0x18,0x48,0x48,0xF8,0xB0,0x00,
  0x00,0x01,0x03,0x02,0x02,0x03,0x01,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xb8, Cyr_i */                        
{ 0x00,0xF8,0xF8,0xC0,0x70,0xF8,0xF8,0x00,
  0x00,0x03,0x03,0x01,0x00,0x03,0x03,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xb9, Cyr_j */                        
{ 0x00,0xF8,0xF8,0xC3,0x71,0xF8,0xF8,0x00,
  0x00,0x03,0x03,0x01,0x00,0x03,0x03,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xba, Cyr_k */                        
{ 0x00,0xF8,0xF8,0x40,0xE0,0xB8,0x18,0x00,
  0x00,0x03,0x03,0x00,0x00,0x03,0x03,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xbb, Cyr_l */                        
{ 0x00,0xC0,0xE0,0x30,0x18,0xF8,0xF8,0x00,
  0x00,0x03,0x03,0x00,0x00,0x03,0x03,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xbc, Cyr_m */                        
{ 0xF8,0xF0,0x60,0xC0,0x60,0xF0,0xF8,0x00,
  0x03,0x03,0x00,0x01,0x00,0x03,0x03,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xbd, Cyr_n */                        
{ 0x00,0xF8,0xF8,0x40,0x40,0xF8,0xF8,0x00,
  0x00,0x03,0x03,0x00,0x00,0x03,0x03,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xbe, Cyr_p */                        
{ 0x00,0xF8,0xF8,0x08,0x08,0xF8,0xF8,0x00,
  0x00,0x03,0x03,0x00,0x00,0x03,0x03,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xbf, Cyr_t */                        
{ 0x00,0x08,0x08,0xF8,0xF8,0x08,0x08,0x00,
  0x00,0x00,0x00,0x03,0x03,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xc0, Cyr_tsch */                     
{ 0x00,0x38,0x78,0x40,0x40,0xF8,0xF8,0x00,
  0x00,0x00,0x00,0x00,0x00,0x03,0x03,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xc1, Cyr_sch */                      
{ 0xF8,0xF8,0x00,0xF8,0x00,0xF8,0xF8,0x00,
  0x03,0x03,0x02,0x03,0x02,0x03,0x03,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xc2, Cyr_hh */                       
{ 0x18,0xF8,0xF8,0x40,0x20,0xE0,0xC0,0x00,
  0x00,0x03,0x03,0x02,0x02,0x03,0x01,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xc3, Cyr_y */                        
{ 0xF8,0xF8,0x20,0xC0,0x00,0xF8,0xF8,0x00,
  0x03,0x03,0x02,0x01,0x00,0x03,0x03,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xc4, Cyr_ww */                       
{ 0x00,0xF8,0xF8,0x40,0x20,0xE0,0xC0,0x00,
  0x00,0x03,0x03,0x02,0x02,0x03,0x01,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xc5, Cyr_e */                        
{ 0x00,0x10,0x08,0x48,0x48,0xF8,0xF0,0x00,
  0x00,0x01,0x02,0x02,0x02,0x03,0x01,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xc6, Cyr_ju */                       
{ 0xF8,0xF8,0x40,0xF0,0x08,0xF8,0xF0,0x00,
  0x03,0x03,0x00,0x01,0x02,0x03,0x01,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xc7, Cyr_ja */                       
{ 0x00,0xB0,0xF8,0x48,0x48,0xF8,0xF8,0x00,
  0x00,0x03,0x03,0x00,0x00,0x03,0x03,0x00 
  },  /* x=0, y=0, w=8, h=16 */
	
 #if 0
 /* 0xc8  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xc9  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xca  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xcb  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xcc  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xcd  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xce  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xcf  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xd0  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xd1  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xd2  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xd3  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xd4  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xd5  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xd6  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xd7  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xd8  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xd9  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xda  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xdb  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xdc  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xdd  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xde  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xdf  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xe0, Cyr_D */                        
{ /* code 00E0 */                         
  0x00,0xFC,0xFE,0x03,0x01,0xFF,0xFF,0x00,
  0x06,0x07,0x03,0x02,0x02,0x03,0x07,0x06 
},                                        
	                                  
 /* 0xe1, Cyr_C */                        
{ /* code 00E1 */                         
  0x00,0xFF,0xFF,0x00,0x00,0xFF,0xFF,0x00,
  0x00,0x03,0x03,0x02,0x02,0x03,0x07,0x06 
},                                        
	                                  
 /* 0xe2, Cyr_Schtsch */                  
{ /* code 00E2 */                         
  0xFF,0xFF,0x00,0xFF,0x00,0xFF,0xFF,0x00,
  0x03,0x03,0x02,0x03,0x02,0x03,0x07,0x07 
},                                        
	                                  
 /* 0xe3, Cyr_d */                        
{ /* code 00E3 */                         
  0x00,0xC0,0xE0,0x30,0x18,0xF8,0xF8,0x00,
  0x06,0x07,0x03,0x02,0x02,0x03,0x07,0x06 
},                                        
	                                  
 /* 0xe4, Cyr_f */                        
{ /* code 00E4 */                         
  0xF0,0xF8,0x08,0xFE,0x08,0xF8,0xF0,0x00,
  0x01,0x03,0x02,0x0F,0x02,0x03,0x01,0x00 
},                                        
	                                  
 /* 0xe5, Cyr_c */                        
{ /* code 00E5 */                         
  0x00,0xF8,0xF8,0x00,0x00,0xF8,0xF8,0x00,
  0x00,0x03,0x03,0x02,0x02,0x03,0x07,0x07 
},                                        
	                                  
 /* 0xe6, Cyr_schtsch */                  
{ /* code 00E6 */                         
  0xF8,0xF8,0x00,0xF8,0x00,0xF8,0xF8,0x00,
  0x03,0x03,0x02,0x03,0x02,0x03,0x07,0x07 
},                                        
	                                  
 /* 0xe7  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xe8  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xe9  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xea  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xeb  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xec  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xed  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xee  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xef  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xf0  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xf1  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xf2  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xf3  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xf4  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xf5  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xf6  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xf7  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xf8  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xf9  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xfa  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xfb  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xfc  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xfd  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */           
	                                  
 /* 0xfe  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 	
  },  /* x=0, y=0, w=8, h=16 */                                                    
	                                                                     
 /* 0xff  */                              
{ 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 
  },  /* x=0, y=0, w=8, h=16 */
           
 #endif                                         
#endif                                    
};
#else
 #ifndef __ASSEMBLER__
extern const unsigned char PROGMEM font[CHAR_COUNT12][(FONT_WIDTH * ((FONT_HEIGHT + 7)/8))];
 #endif                                    
#endif                                    
