#include <stdio.h>
#include <math.h>

#define R_L 680
#define PIN_L 19.0
#define PIN_H 22.3

int main(int argc, char *argv[])
{
 double Tau,rgesamt;
 double induct_l, induct_r;
 double uu, umax;
 double tt;
 if (argc != 3) {
    fprintf(stdout,"Zahl der Argumente: %d",argc-1);
    fprintf(stdout,"Argument 1: Induktivität\r\n");
    fprintf(stdout,"Argument 2: Widerstandswert\r\n");
    exit(0);
 }
 induct_l = 0.0068;
 induct_r = 6.7 + 20;
 sscanf(argv[1],"%lf",&induct_l);
 sscanf(argv[2],"%lf",&induct_r);
 if (induct_r < 24) {
   rgesamt = PIN_L + PIN_H + induct_r;
   umax = 5 * PIN_L  / rgesamt;
 } else {
   rgesamt = PIN_L + PIN_H + R_L + induct_r;
   umax = 5 * (PIN_L + R_L) / rgesamt;
 }
 Tau = induct_l / rgesamt;
 for (tt=0.0; tt<1.0; tt+=0.000000125){
    uu = umax * (1. - exp(-tt/Tau));
    fprintf(stdout,"%.1f %.3f\r\n", tt*8000000.,uu);
    if (uu  > 1.2) break;
 }
 fprintf(stdout,"L=%f H\r\n", induct_l );
 fprintf(stdout,"L=%f Ohm\r\n", induct_r );
 fprintf(stdout,"rgesamt=%.1f\r\n", rgesamt);
 fprintf(stdout,"umax=%.3f ",umax);
 fprintf(stdout,"percent=%.1f\r\n", 110 / umax);
 exit(0);
}
