/*
  Modbus-Arduino Example - Test Led (Modbus IP ESP8266)
  Control a Led on GPIO0 pin using Write Single Coil Modbus Function 
  Original library
  Copyright by André Sarmento Barbosa
  http://github.com/andresarmento/modbus-arduino

  Current version
  (c)2017 Alexander Emelianov (a.m.emelianov@gmail.com)
  https://github.com/emelianov/modbus-esp8266
*/

#ifdef ESP8266
 #include <ESP8266WiFi.h>
#else //ESP32
 #include <WiFi.h>
#endif
#include <ModbusIP_ESP8266.h>
//Modbus TCP server port 502

//Modbus Registers Offsets
const int LED_COIL = 100;	//Coil (Relay) address 00101
const int BUTON_STS = 100;	//Input Status address 10101
const int TEST_IREG = 100;	//Input Register address 30101
const int TEST_HREG = 100;	//Holding Register address 40101

//Pinii folositi:
				 // GPIO36 -> A0
const int ledPin = 2;	 // GPIO2 - NodeMCU32s
const int butonPin = 0; // GPIO0 - NodeMCU32s

long ts;

//ModbusIP object
ModbusIP mb;
  
void setup() {
  Serial.begin(115200);
 
  WiFi.begin("Acasuca_2.4G", "kNY2ph3mmrnT6zk4");
  
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }//end while
 
  Serial.println("");
  Serial.println("WiFi connected");  
  Serial.println("IP address: ");
  Serial.println(WiFi.localIP());

  mb.server();

  pinMode(ledPin, OUTPUT);
  pinMode(butonPin, INPUT);

  mb.addCoil(LED_COIL);
  mb.addIsts(BUTON_STS);
  mb.addIreg(TEST_IREG, 1234);
  mb.addHreg(TEST_HREG, 5678);
    ts = millis();
}//end setup

void loop() {
   //Call once inside loop() - all magic here
   mb.task();

   //Attach ledPin to LED_COIL register
   digitalWrite(ledPin, mb.Coil(LED_COIL));

   //Attach switchPin to BUTON_STS register
   mb.Ists(BUTON_STS, digitalRead(butonPin));

  //Read each two seconds
   if (millis() >= ts + 1000) {
       ts = millis();
       //Setting raw value (0-4095)
       mb.Ireg(TEST_IREG, analogRead(A0));	//Pin GPIO36
   
   Serial.print(mb.Ireg(100)); Serial.write(0x20);
   Serial.println(mb.Hreg(100));
  }
  delay(10);
}//end loop
