
#include <WiFi.h>
//#include <WiFiClient.h>
#include <SimplePgSQL.h>


// current temperature & humidity, updated in loop()
float t = 0.0;
float h = 0.0;

//Setup connection and Database=====================
const char* ssid = "Acasuca_2.4G";
const char* pass = "kNY2ph3mmrnT6zk4";
WiFiClient client;

IPAddress PGIP(193, 226, 5, 178);     // your PostgreSQL server IP
const char user[] = "esp32";       // your database user
const char password[] = "asa123";   // your database password
const char dbname[] = "esp32_db";         // your database name
char buffer[1024];

PGconnection conn(&client, 0, 1024, buffer);

char inbuf[128];
int pg_status = 0;
//Setup connection and Database=====================

//millis================================
//Set every 60 sec read DHT
unsigned long previousMillis = 0;  // variable to store the last time the task was run
const unsigned long interval = 600000;        // time interval in milliseconds (eg 1000ms = 1 second)
//======================================

void setup() {
  Serial.begin(115200);
  
  WiFi.begin(ssid, pass);
  Serial.println("Connecting");
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }
  Serial.println("");
  Serial.print("Connected to WiFi network with IP Address: ");
  Serial.println(WiFi.localIP());

  Serial.println("Timer set to 600 seconds (timerDelay variable), it will take 60 seconds before publishing the first reading.");
} //end setup

void doPg(void)
{
  char *msg;
  int rc;
  if (!pg_status) {
    conn.setDbLogin(PGIP,
                    user,
                    password,
                    dbname,
                    "utf8");
    pg_status = 1;
    return;
  }

  if (pg_status == 1) {
    rc = conn.status();
    if (rc == CONNECTION_BAD || rc == CONNECTION_NEEDED) {
      char *c = conn.getMessage();
      if (c) Serial.println(c);
      pg_status = -1;
    }
    else if (rc == CONNECTION_OK) {
      pg_status = 2;
      Serial.println("Starting query");
    }
    return;
  }
  
  if (pg_status == 2 && strlen(inbuf) > 0) {
    if (conn.execute(inbuf)) goto error;
    Serial.println("Executed query OK...");
//    conn.close();
//    pg_status = 0;
    pg_status = 3;
    memset(inbuf, 0, sizeof(inbuf));
  }
  
  if (pg_status == 3) {
    rc = conn.getData();
    int i;
    if (rc < 0) goto error;
    if (!rc) return;
    if (rc & PG_RSTAT_HAVE_COLUMNS) {
      for (i = 0; i < conn.nfields(); i++) {
        if (i) Serial.print(" | ");
        Serial.print(conn.getColumn(i));
      }
      Serial.println("\n==========");
    }
    else if (rc & PG_RSTAT_HAVE_ROW) {
      for (i = 0; i < conn.nfields(); i++) {
        if (i) Serial.print(" | ");
        msg = conn.getValue(i);
        if (!msg) msg = (char *)"NULL";
        Serial.print(msg);
      }
      Serial.println();
    }
    else if (rc & PG_RSTAT_HAVE_SUMMARY) {
      Serial.print("Rows affected: ");
      Serial.println(conn.ntuples());
    }
    else if (rc & PG_RSTAT_HAVE_MESSAGE) {
      msg = conn.getMessage();
      if (msg) Serial.println(msg);
    }
    if (rc & PG_RSTAT_READY) {
      pg_status = 2;
      Serial.println("Waiting query");
    }
  }
  return;
error:
  msg = conn.getMessage();
  if (msg) Serial.println(msg);
  else Serial.println("UNKNOWN ERROR");
  if (conn.status() == CONNECTION_BAD) {
    Serial.println("Connection is bad");
    pg_status = -1;
  }
} //end doPG

void loop() {
  delay(50);
  doPg();
  unsigned long currentMillis = millis();  // mendapatkan waktu sekarang
  // Checks whether it is time to run the task
  if (currentMillis - previousMillis >= interval) {
    // Save the last time the task was run
    previousMillis = currentMillis;
    if (WiFi.status() == WL_CONNECTED) {
      //read some parameters ---------------------------------------
      t = analogRead(A4);	//25.5;
      h = analogRead(A5);	//65.5;
      Serial.print("Humidity = ");
      Serial.print(h);
      Serial.print("% ");
      Serial.print("Temperature = ");
      Serial.print(t);
      Serial.println(" C ");
      //read some parameters ---------------------------------------
      //Send data to PostgreSQL using inbuff

      sprintf(inbuf, "INSERT INTO esp32_th_tb (temp,humidity) VALUES(%.2f,%.2f)", t, h);      
    }
    else {
      Serial.println("WiFi Disconnected");
    }
    
  }
}
