#include <ESP32Time.h>

// change next line to use with another board/shield
#include <WiFi.h>
#include <WiFiUdp.h>

const char *ssid     = "Acasuca_2.4G";
const char *password = "kNY2ph3mmrnT6zk4";

ESP32Time rtc(3600);  // offset in seconds GMT+1

const unsigned long GMT_Offset = 7200;	// in seconds
const unsigned long daylightOffset = 0;	// in seconds

// You can specify the time server pool and the offset (in seconds, can be
// changed later with setTimeOffset() ). Additionaly you can specify the
// update interval (in milliseconds, can be changed using setUpdateInterval() ).

void setup(){
  Serial.begin(115200);

  WiFi.begin(ssid, password);

  while ( WiFi.status() != WL_CONNECTED ) {
    delay ( 500 );
    Serial.print ( "." );
  }
    Serial.println( "WiFi Connected OK!" );

/*-------- set Date/Time with NTP --------------*/

   adjustTime();

} // end setup

void loop() {

if ( rtc.getTime("%T") == "14:40:00" )
{
adjustTime();
}

//  Serial.println(rtc.getTime("%F %H:%M:%S"));   // (String) returns 2024-06-23 14:25:51 == %T == %X 

  Serial.println(rtc.getTime("%Y-%m-%d %H:%M:%S"));   // (String) returns 2024-06-23 14:25:51 format 

  delay(1000);
} // end loop

void adjustTime()
{
//  configTime(gmtOffset_sec, daylightOffset_sec, ntpServer);
  configTime(GMT_Offset, daylightOffset, "europe.pool.ntp.org");

  struct tm timeinfo;
  if (getLocalTime(&timeinfo)){
    rtc.setTimeStruct(timeinfo); 
     Serial.println( "NTP Server Connected OK, Date/Time adjusted" );
 }
} // end adjustTime



