/******************************************************************
Author Florin Dragan <florind@mas.utcluj.ro>
Version 1.0.2 07-01-2025
ESP32 as PostgreSQL client example. Measure two analog read parameters
and sends them to a table residing into a PostgreSQL database server
Example uses SimplePgSQL.h library, modified by myself, to be compatible with
Arduinp ESP32 core version 3.0.x

The system reads some values, but example can be modified for many other
similar variables.

*******************************************************************/

#include <WiFi.h>
#include <ESP32Time.h>
#include <SimplePgSQL.h>

// current temperature & humidity, updated in loop()
float t = 0.0;
float h = 0.0;

// Setup connection, NTP time and Database servers ====================
const char* ssid = "Acasuca_2.4G";
const char* pass = "kNY2ph3mmrnT6zk4";

// Initialize WiFi instance object
WiFiClient client;

// NTP Server parameters (offset, daylight)
const char* ntpServer = "europe.pool.ntp.org";
const unsigned long GMT_Offset = 3600;	// in seconds
const unsigned long daylightOffset = 3600;	// in seconds

ESP32Time rtc(3600);  // offset in seconds GMT+1


IPAddress PGIP(193, 226, 5, 178);     // your PostgreSQL server IP
const char user[] = "esp32";       // your database user
const char password[] = "asa123";   // your database password
const char dbname[] = "esp32_db";         // your database name
char buffer[1024];

PGconnection conn(&client, 0, 1024, buffer);

char inbuf[128];
int pg_status = 0;
// Setup connection and Database =====================

// Set reading iterval at every 10 minutes

// Variable to store the last time the task was run
byte minut, minut_vechi=0;
const byte perioada = 2;        // time interval in minute

void setup() {
  Serial.begin(115200);
  
  WiFi.begin(ssid, pass);
  Serial.println("Connecting");
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }
  Serial.println("");
  Serial.print("Connected to WiFi network with IP Address: ");
  Serial.println(WiFi.localIP());

// Set Date/Time with NTP
  Serial.println("Adjust Date/Time using NTP Server.");
   adjustTime();

// (String) returns 2024-06-23 14:25:51 format 
  Serial.println(rtc.getTime("%Y-%m-%d %H:%M:%S"));

} //end setup


void adjustTime() {
// configTime(gmtOffset_sec, daylightOffset_sec, ntpServer);
  configTime(GMT_Offset, daylightOffset, ntpServer);

  struct tm timeinfo;
  if (getLocalTime(&timeinfo)){
    rtc.setTimeStruct(timeinfo); 
     Serial.println( "NTP Server Connected OK, Date/Time adjusted" );
 }
} // end adjustTime

// Function acting as PostgreSQL communication Client
void doPg(void)
{
  char *msg;
  int rc;
  if (!pg_status) {
// Login sequence to PostgreSQL server and database
    conn.setDbLogin(PGIP,
                    user,
                    password,
                    dbname,
                    "utf8");
    pg_status = 1;
    return;
  }

  if (pg_status == 1) {
    rc = conn.status();
    if (rc == CONNECTION_BAD || rc == CONNECTION_NEEDED) {
      char *c = conn.getMessage();
      if (c) Serial.println(c);
      pg_status = -1;
    }
    else if (rc == CONNECTION_OK) {
      pg_status = 2;
      Serial.println("Starting query");
    }
    return;
  }
  
  if (pg_status == 2 && strlen(inbuf) > 0) {
    if (conn.execute(inbuf)) goto error;
    Serial.println("Executed query OK...");
//    conn.close();
//    pg_status = 0;
    pg_status = 3;
    memset(inbuf, 0, sizeof(inbuf));
  }
  
  if (pg_status == 3) {
    rc = conn.getData();
    int i;
    if (rc < 0) goto error;
    if (!rc) return;

// If a query returns table content, this sequence prints
// columns separated by " | " and spaces
    if (rc & PG_RSTAT_HAVE_COLUMNS) {
      for (i = 0; i < conn.nfields(); i++) {
        if (i) Serial.print(" | ");
        Serial.print(conn.getColumn(i));
      }
      Serial.println("\n==========");
    }
    else if (rc & PG_RSTAT_HAVE_ROW) {
      for (i = 0; i < conn.nfields(); i++) {
        if (i) Serial.print(" | ");
        msg = conn.getValue(i);
        if (!msg) msg = (char *)"NULL";
        Serial.print(msg);
      }
      Serial.println();
    }
    else if (rc & PG_RSTAT_HAVE_SUMMARY) {
      Serial.print("Rows affected: ");
      Serial.println(conn.ntuples());
    }
    else if (rc & PG_RSTAT_HAVE_MESSAGE) {
      msg = conn.getMessage();
      if (msg) Serial.println(msg);
    }
    if (rc & PG_RSTAT_READY) {
      pg_status = 2;
      Serial.println("Waiting query");
    }
  }
  return;
// Error label where some section bad returns to
error:
  msg = conn.getMessage();
  if (msg) Serial.println(msg);
  else Serial.println("UNKNOWN ERROR");
  if (conn.status() == CONNECTION_BAD) {
    Serial.println("Connection is bad");
    pg_status = -1;
  }
} //end doPG

void loop() {

// Scheduled adjusting time every day at 04:40 
if ( rtc.getTime("%T") == "04:40:00" ) { adjustTime(); }

// Starts running timed stamped measurements at
// precise period equal with "perioada"

  minut = rtc.getMinute();

  // Checks whether it is time to run the task
  if ((minut%perioada == 0) && (minut_vechi != minut)) {
    // Save the last time the task was run
    minut_vechi = minut;

//  Serial.println(rtc.getTime("%F %H:%M:%S"));
// (String) returns 2024-06-23 14:25:51 echjivalent with %T and %X
// or better, more explicitely, like in the next lines :=)

// (String) returns 2024-06-23 14:25:51 format
  Serial.println(rtc.getTime("%Y-%m-%d %H:%M:%S"));

// If WiFi properely connected, do measurements
// and prints values to serial console!

   if (WiFi.status() == WL_CONNECTED) {
      //read some parameters ---------------------------------------
      t = analogRead(A4)/100.0;	//25.5;
      h = analogRead(A5)/10.0;	//65.5;
      Serial.print("Humidity = ");
      Serial.print(h);
      Serial.print("% ");
      Serial.print("Temperature = ");
      Serial.print(t);
      Serial.println(" C ");
      //read some parameters ---------------------------------------

// Populate data to be send to PostgreSQL server, using "inbuf"

int inbuf_size = sprintf(inbuf, "INSERT INTO esp32_th_tb (an,luna,zi,zi_sapt,ora,min,sec,temp,humidity) VALUES(%d,%d,%d,%d,%d,%d,%d,%.2f,%.2f)", rtc.getYear(),rtc.getMonth()+1,rtc.getDay(),rtc.getDayofWeek(),rtc.getHour(true),rtc.getMinute(),rtc.getSecond(),t,h);

Serial.println(inbuf);
Serial.println(inbuf_size);

    }
    else {
      Serial.println("WiFi Disconnected");
    }
    
  }//end if minut

  delay(50);
  doPg();

}//end loop
