#include "SSD1306_SPI.h"
#include <SPI.h>

SSD1306_SPI::SSD1306_SPI()
{
}

void SSD1306_SPI::begin(bool invert)
{
	this->begin(invert, 0x7f);
}

void SSD1306_SPI::begin(bool invert, uint8_t contrast)
{
	pinMode(PIN_RESET, OUTPUT);
	pinMode(PIN_CE, OUTPUT);
	pinMode(PIN_DC, OUTPUT);
	digitalWrite(PIN_RESET, HIGH);
	digitalWrite(PIN_CE, HIGH);
	digitalWrite(PIN_DC, HIGH);

	SPI.begin();
	
	// LCD init section:
	// Must reset LCD first!

	digitalWrite(PIN_RESET, LOW);
delayMicroseconds(10);
	digitalWrite(PIN_RESET, HIGH);
delay(100);

	this->writeDisplay(SSD1306_COMMAND, 0xAE); // Set display OFF	

	this->writeDisplay(SSD1306_COMMAND, 0xD4); // Set Display Clock Divide Ratio / OSC Frequency
	this->writeDisplay(SSD1306_COMMAND, 0x80); // Display Clock Divide Ratio / OSC Frequency 

	this->writeDisplay(SSD1306_COMMAND, 0xA8); // Set Multiplex Ratio
	this->writeDisplay(SSD1306_COMMAND, 0x3f); // Multiplex Ratio for 128x64 (64-1)

	this->writeDisplay(SSD1306_COMMAND, 0xD3); // Set Display Offset
	this->writeDisplay(SSD1306_COMMAND, 0x00); // Display Offset

	this->writeDisplay(SSD1306_COMMAND, 0x40);// Set Display Start Line

	this->writeDisplay(SSD1306_COMMAND, 0x8D); // Set Charge Pump
	this->writeDisplay(SSD1306_COMMAND, 0x14); // Charge Pump (0x10 External, 0x14 Internal DC/DC)

	this->writeDisplay(SSD1306_COMMAND, 0xA1); // Set Segment Re-Map
	this->writeDisplay(SSD1306_COMMAND, 0xC8); // Set Com Output Scan Direction

	this->writeDisplay(SSD1306_COMMAND, 0xDA); // Set COM Hardware Configuration
	this->writeDisplay(SSD1306_COMMAND, 0x12); // COM Hardware Configuration

	this->writeDisplay(SSD1306_COMMAND, 0x81); // Set Contrast
	this->writeDisplay(SSD1306_COMMAND, contrast); // Contrast 0-255 (CF)

	this->writeDisplay(SSD1306_COMMAND, 0xD9); // Set Pre-Charge Period
	this->writeDisplay(SSD1306_COMMAND, 0xF1); // Set Pre-Charge Period (0x22 External, 0xF1 Internal)

	this->writeDisplay(SSD1306_COMMAND, 0xDB); // Set VCOMH Deselect Level
	this->writeDisplay(SSD1306_COMMAND, 0x40); // VCOMH Deselect Level

	this->writeDisplay(SSD1306_COMMAND, 0xA4); // Set all pixels OFF
	this->writeDisplay(SSD1306_COMMAND, 0xA6 | invert); // Set 0 display not inverted

	this->writeDisplay(SSD1306_COMMAND, 0xAF); // Set display On

	// Set horizontal addressing mode
	this->writeDisplay(SSD1306_COMMAND, 0x20);
	this->writeDisplay(SSD1306_COMMAND, 0x00);

	this->clear();
}

size_t SSD1306_SPI::write(uint8_t data)
{
	// Non-ASCII characters are not supported.
	if (data < 0x20 || data > 0x7F) return 0;

	uint8_t buf[6];
	memcpy_P(buf, ASCII[data - 0x20], 5);
	buf[5] = 0x00;
	this->writeDisplay(SSD1306_DATA, buf, 6);
	this->advanceXY(6);
	return 1;
}

void SSD1306_SPI::clear()
{
	// set column start and end address
	this->writeDisplay(SSD1306_COMMAND, 0x21);  // set column start and end address
	this->writeDisplay(SSD1306_COMMAND, 0x00);	// start at 0
	this->writeDisplay(SSD1306_COMMAND, 0x7f);	// end at 127
	// set row start and end address
	this->writeDisplay(SSD1306_COMMAND, 0x22);	// set column start and end address
	this->writeDisplay(SSD1306_COMMAND, 0x00);	// start at 0
	this->writeDisplay(SSD1306_COMMAND, 0x07);	// end at 7

	for (uint16_t i = 0; i < BUF_LEN; i++)
		this->writeDisplay(SSD1306_DATA, 0x00);
	
	// set page addressing mode
	//this->writeDisplay(SSD1306_COMMAND, 0x20);
	//this->writeDisplay(SSD1306_COMMAND, 0x02);

	this->gotoXY(0, 0);
}

uint8_t SSD1306_SPI::gotoXY(uint8_t x, uint8_t y) 
{	
	if (x >= SSD1306_X_PIXELS || y >= SSD1306_ROWS) return SSD1306_ERROR;
	//SPI.transfer(0x80 | x);
	//SPI.transfer(0x40 | y);
	//SSD1306_PORT |= PIN_CE;
	this->writeDisplay(SSD1306_COMMAND, 0x21);  // set column start and end address
	this->writeDisplay(SSD1306_COMMAND, x);		// set column start address
	this->writeDisplay(SSD1306_COMMAND, 0x7f);	// set column end address
	this->writeDisplay(SSD1306_COMMAND, 0x22);	// set column start and end address
	this->writeDisplay(SSD1306_COMMAND, y);		// set row start address
	this->writeDisplay(SSD1306_COMMAND, 0x07);	// set row end address
	this->m_Column = x;
	this->m_Line = y;
	return SSD1306_SUCCESS;
}

uint8_t SSD1306_SPI::writeBitmap(const uint8_t *bitmap, uint8_t x, uint8_t y, uint8_t width, uint8_t height)
{
//this->gotoXY(x, y);
if (this->gotoXY(x, y) == SSD1306_ERROR) return SSD1306_ERROR;

byte i, j;
uint16_t len_ = width * height;


for (i=0; i<height; i++){
this->gotoXY(x, y+i);

	for (j=0; j<width; j++)
  {
writeDisplay(SSD1306_DATA, bitmap[(i*width)+j]);
if((i*width)+j > len_) break;
  }
if((i*width)+j > len_) break;
}
return len_;

/*
	//if (x >= SSD1306_X_PIXELS || y >= SSD1306_ROWS) return;
	////height = (this->m_Line + height > SSD1306_Y_PIXELS / 8) ? ((SSD1306_Y_PIXELS / 8) - this->m_Line) : height;
	////width = (this->m_Column + width > SSD1306_X_PIXELS) ? (SSD1306_X_PIXELS - this->m_Column) : width;
	//this->gotoXY(x, y);
	//this->advanceXY(width);
	
	if (this->gotoXY(x, y) == SSD1306_ERROR) return SSD1306_ERROR;

	const uint8_t *maxY = bitmap + height * width;	

	for (const uint8_t *y = bitmap; y < maxY; y += width)
	{
		//for (uint8_t x = 0; x < width; x++, y++)
		//	this->writeDisplay(SSD1306_DATA, *y);
		
		this->writeDisplay(SSD1306_DATA, y , width);
		this->gotoXY(this->m_Column, this->m_Line + 1);
	}

	this->advanceXY(width);
*/

}

void SSD1306_SPI::advanceXY(uint8_t columns)
{
	this->m_Column += columns;
	if (this->m_Column >= SSD1306_X_PIXELS)
	{
		this->m_Column %= SSD1306_X_PIXELS;
		this->m_Line++;
		this->m_Line %= SSD1306_ROWS;
		//this->gotoXY(this->m_Column, m_Line);
	}
}

void SSD1306_SPI::writeDisplay(uint8_t dataOrCommand, const uint8_t *data, uint16_t count)
{
	digitalWrite(PIN_CE, LOW);
	digitalWrite(PIN_DC, dataOrCommand);
//	NOP16;
    for (uint16_t i = count; i > 0; i--)

	SPI.transfer(data[count-i]);
//	NOP16;
	digitalWrite(PIN_CE, HIGH);
}

void SSD1306_SPI::writeDisplay(uint8_t dataOrCommand, uint8_t data)
{
	digitalWrite(PIN_CE, LOW);
	digitalWrite(PIN_DC, dataOrCommand);
//	NOP16;

	SPI.transfer(data);

//	NOP16;
	digitalWrite(PIN_CE, HIGH);
}

