#include <SPI.h>
#include "SSD1306_SPI.h"
#include <ESP32Time.h>
#include <WiFi.h>
#include <WiFiUdp.h>

// It is very important to wire the LCD correctly. 
// The following is the default wiring configuration for an ESP32 based NodeMCU32:
// PIN_DC	2	//GPIO2
// PIN_RESET	13	//GPIO13
// PIN_CE	5	//GPIO5
// PIN_SDIN	23	//GPIO23
// PIN_SCLK	18	//GPIO18

const char *ssid     = "Acasuca_2.4G";
const char *password = "kNY2ph3mmrnT6zk4";

const unsigned long GMT_Offset = 7200;	// in seconds
const unsigned long daylightOffset = 0;	// in seconds


// Initiakize display library object
SSD1306_SPI oled;
ESP32Time rtc(3600);  // offset in seconds GMT+1
WiFiUDP ntpUDP;

void setup(void)
{
	Serial.begin(115200);

  WiFi.begin(ssid, password);

  while ( WiFi.status() != WL_CONNECTED ) {
    delay(500);
    Serial.print ( "." );
  }
    Serial.println( "WiFi Connected OK!" );
   configTime(7200, 0, "europe.pool.ntp.org");
  struct tm timeinfo;
  if (getLocalTime(&timeinfo)){
    rtc.setTimeStruct(timeinfo); 
  }
	oled.begin(0, 128); //(mod, contrast): mod 0-normal/1-invers, contrast 0-255

	adjustTime();

}//end setup


void loop(void) 
{
if ( rtc.getTime("%T") == "14:40:00" )
{
adjustTime();
}
  Serial.println(rtc.getTime("%Y-%m-%d %H:%M:%S"));   // (String) returns 2024-06-23 14:25:51 format 

	oled.clear();
	oled.gotoXY(0,1);
	oled.print("Data: ");
//	oled.gotoXY(10,2);
	oled.println(rtc.getTime("%Y-%m-%d"));

	oled.gotoXY(0,4);
	oled.println("Ora: ");
//	oled.gotoXY(10,5);
	oled.println(rtc.getTime(" %H:%M:%S"));

	delay(1000);
}//end loop


void adjustTime()
{
//  configTime(gmtOffset_sec, daylightOffset_sec, ntpServer);
  configTime(GMT_Offset, daylightOffset, "europe.pool.ntp.org");

  struct tm timeinfo;
  if (getLocalTime(&timeinfo)){
    rtc.setTimeStruct(timeinfo); 
     Serial.println( "NTP Server Connected OK, Date/Time adjusted" );
 }
} // end adjustTime






