#include <Wire.h>
#include "SSD1306_I2C.h"

// It is very important to wire the LCD correctly. 
// The following is the default wiring configuration for an ESP32 based NodeMCU32:

// PIN_SDA	21	//GPIO21
// PIN_SCL	22	//GPIO22

// Initiakize display library object

SSD1306_I2C oled;

void setup(void)
{
	Serial.begin(115200);
	oled.begin(0, 128);	//(mod, contrast): mod 0-normal/1-invers, contrast 0-255
	oled.print(F("Preparing benchmark")); // Put the strinh into Flash memory, not in RAM
	delay(5000);
}

void loop(void) 
{
	byte len;

	oled.clear();
	len = oled.print(F("0123456789_ABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyz{}[]()*&^%$!#~@;;<>?"));
	oled.gotoXY(0,5);
	oled.print(F("Lungime text: "));
	oled.print(len);
	delay(15000);

	oled.clear();
	oled.gotoXY(0,2);
	oled.print(F("Acesta este un test")); // Max 21 characters per row 128/6 = 21.333
	oled.gotoXY(0,3);
	oled.print(F("de scriere text"));
	oled.gotoXY(0,5);
	oled.print(F("Permite 8 linii cu"));
	oled.gotoXY(0,6);
	oled.print(F("Maxim 21 caractere"));
	delay(15000);

}
