#include "SSD1306_I2C.h"
#include <Wire.h>

SSD1306_I2C::SSD1306_I2C()
{
}

void SSD1306_I2C::begin(bool invert)
{
	this->begin(invert, 0x7f);
}

void SSD1306_I2C::begin(bool invert, uint8_t contrast)
{
	Wire.begin();
	Wire.setClock(400000);
		Wire.beginTransmission(i2c_addr);
		Wire.write(SSD1306_COMMAND);

	// LCD init section:

	this->writeDisplay(SSD1306_COMMAND, 0xAE); // Set display OFF	

	this->writeDisplay(SSD1306_COMMAND, 0xD4); // Set Display Clock Divide Ratio / OSC Frequency
	this->writeDisplay(SSD1306_COMMAND, 0x80); // Display Clock Divide Ratio / OSC Frequency 

	this->writeDisplay(SSD1306_COMMAND, 0xA8); // Set Multiplex Ratio
	this->writeDisplay(SSD1306_COMMAND, 0x3f); // Multiplex Ratio for 128x64 (64-1)

	this->writeDisplay(SSD1306_COMMAND, 0xD3); // Set Display Offset
	this->writeDisplay(SSD1306_COMMAND, 0x00); // Display Offset

	this->writeDisplay(SSD1306_COMMAND, 0x40);// Set Display Start Line

	this->writeDisplay(SSD1306_COMMAND, 0x8D); // Set Charge Pump
	this->writeDisplay(SSD1306_COMMAND, 0x14); // Charge Pump (0x10 External, 0x14 Internal DC/DC)

	this->writeDisplay(SSD1306_COMMAND, 0xA1); // Set Segment Re-Map
	this->writeDisplay(SSD1306_COMMAND, 0xC8); // Set Com Output Scan Direction

	this->writeDisplay(SSD1306_COMMAND, 0xDA); // Set COM Hardware Configuration
	this->writeDisplay(SSD1306_COMMAND, 0x12); // COM Hardware Configuration

	this->writeDisplay(SSD1306_COMMAND, 0x81); // Set Contrast
	this->writeDisplay(SSD1306_COMMAND, contrast); // Contrast 0-255 (CF)

	this->writeDisplay(SSD1306_COMMAND, 0xD9); // Set Pre-Charge Period
	this->writeDisplay(SSD1306_COMMAND, 0xF1); // Set Pre-Charge Period (0x22 External, 0xF1 Internal)

	this->writeDisplay(SSD1306_COMMAND, 0xDB); // Set VCOMH Deselect Level
	this->writeDisplay(SSD1306_COMMAND, 0x40); // VCOMH Deselect Level

	this->writeDisplay(SSD1306_COMMAND, 0xA4); // Set all pixels OFF
	this->writeDisplay(SSD1306_COMMAND, 0xA6 | invert); // Set 0 display not inverted

	this->writeDisplay(SSD1306_COMMAND, 0xAF); // Set display On

	// Set horizontal addressing mode
	this->writeDisplay(SSD1306_COMMAND, 0x20);
	this->writeDisplay(SSD1306_COMMAND, 0x00);

	Wire.endTransmission();

	this->clear();
}

size_t SSD1306_I2C::write(uint8_t data)
{
	// Non-ASCII characters are not supported.
	if (data < 0x20 || data > 0x7F) return 0;

	uint8_t buf[6];
	memcpy_P(buf, ASCII[data - 0x20], 5);
	buf[5] = 0x00;
	this->writeDisplay(SSD1306_DATA, buf, 6);
	Wire.endTransmission();
	this->advanceXY(6);
	Wire.endTransmission();
	return 1;
}

void SSD1306_I2C::clear()
{
	// set column start and end address
	this->writeDisplay(SSD1306_COMMAND, 0x21);  // set column start and end address
	this->writeDisplay(SSD1306_COMMAND, 0x00);	// start at 0
	this->writeDisplay(SSD1306_COMMAND, 0x7f);	// end at 127
	// set row start and end address
	this->writeDisplay(SSD1306_COMMAND, 0x22);	// set column start and end address
	this->writeDisplay(SSD1306_COMMAND, 0x00);	// start at 0
	this->writeDisplay(SSD1306_COMMAND, 0x07);	// end at 7
	Wire.endTransmission();

	for (uint16_t i = 0; i < BUF_LEN; i++)
		this->writeDisplay(SSD1306_DATA, 0x00);
	
	// set page addressing mode
	//this->writeDisplay(SSD1306_COMMAND, 0x20);
	//this->writeDisplay(SSD1306_COMMAND, 0x02);
	Wire.endTransmission();

	this->gotoXY(0, 0);
}

uint8_t SSD1306_I2C::gotoXY(uint8_t x, uint8_t y) 
{	
	if (x >= SSD1306_X_PIXELS || y >= SSD1306_ROWS) return SSD1306_ERROR;
	this->writeDisplay(SSD1306_COMMAND, 0x21);  // set column start and end address
	this->writeDisplay(SSD1306_COMMAND, x);		// set column start address
	this->writeDisplay(SSD1306_COMMAND, 0x7f);	// set column end address
	this->writeDisplay(SSD1306_COMMAND, 0x22);	// set column start and end address
	this->writeDisplay(SSD1306_COMMAND, y);		// set row start address
	this->writeDisplay(SSD1306_COMMAND, 0x07);	// set row end address
	Wire.endTransmission();

	this->m_Column = x;
	this->m_Line = y;
	return SSD1306_SUCCESS;
}

uint8_t SSD1306_I2C::writeBitmap(const uint8_t *bitmap, uint8_t x, uint8_t y, uint8_t width, uint8_t height)
{
//this->gotoXY(x, y);
//Wire.endTransmission();
if (this->gotoXY(x, y) == SSD1306_ERROR) return SSD1306_ERROR;

byte i, j;
uint16_t len_ = width * height;

for (i=0; i<height; i++){
this->gotoXY(x, y+i);
	for (j=0; j<width; j++)
  {
writeDisplay(SSD1306_DATA, bitmap[(i*width)+j]);
if((i*width)+j > len_) break;
  }
if((i*width)+j > len_) break;
}
Wire.endTransmission();
return len_;
}

void SSD1306_I2C::advanceXY(uint8_t columns)
{
	this->m_Column += columns;
	if (this->m_Column >= SSD1306_X_PIXELS)
	{
		this->m_Column %= SSD1306_X_PIXELS;
		this->m_Line++;
		this->m_Line %= SSD1306_ROWS;
		//this->gotoXY(this->m_Column, m_Line);
	}
}

void SSD1306_I2C::writeDisplay(uint8_t dataOrCommand, const uint8_t *data, uint16_t count)
{
		Wire.endTransmission();
		Wire.beginTransmission(i2c_addr);
		Wire.write(dataOrCommand);

    for (uint16_t i = count; i > 0; i--)
		Wire.write(data[count-i]);

		Wire.endTransmission();
}

void SSD1306_I2C::writeDisplay(uint8_t dataOrCommand, uint8_t data)
{
	if(Wire.write(data) == 0) {
		Wire.endTransmission();
		Wire.beginTransmission(i2c_addr);
		Wire.write(dataOrCommand);
		Wire.write(data);
	}
}

